/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

/**
    @file FlameGunProjectile.h
    @brief Definition of the FlameGunProjectile class.
*/

#ifndef _FlameGunProjectile_H__
#define _FlameGunProjectile_H__

#include "weapons/WeaponsPrereqs.h"

#include <string>
#include "tools/Timer.h"
#include "ParticleProjectile.h"

namespace orxonox
{

    /**
    @author
        Fabien Vultier
    @ingroup WeaponsProjectiles
    */
    class _WeaponsExport FlameGunProjectile : public ParticleProjectile
    {
        public:
            FlameGunProjectile(Context* context);
            virtual ~FlameGunProjectile() {}

            virtual void setLifetime(float lifetime);
            virtual void setSpread(float spread);
        protected:
            bool processCollision(WorldEntity* otherObject, btManifoldPoint& contactPoint, const btCollisionShape* cs);

        private:            
            float lifetime_;
            float spread_;
            Timer flameTimer_;
    };
}

#endif /* _FlameGunProjectile_H__ */
