/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

#ifndef _HUDShieldBar_H__
#define _HUDShieldBar_H__

#include "overlays/OverlaysPrereqs.h"

#include "tools/interfaces/Tickable.h"
#include "HUDBar.h"

namespace orxonox
{
    /**
    @brief
        The HUDShieldBar displays the the status of the shield of its owner (a @ref Pawn).
        The length of the bar is given by the ratio of the shield health and the maximal shield health of the @ref Pawn.
    */

    class _OverlaysExport HUDShieldBar : public HUDBar, public Tickable
    {
    public:
        HUDShieldBar(Context* context);
        virtual ~HUDShieldBar();

        virtual void tick(float dt) override;
        virtual void changedOwner() override;

        inline void setShieldBarOwner(Pawn* owner)
            { this->owner_ = owner; }
    private:
        Pawn* owner_;
    };
}
#endif /* _HUDShieldBar_H__ */
