/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

#ifndef _HUDEnemyShieldBar_H__
#define _HUDEnemyShieldBar_H__

#include "HUDShieldBar.h"

namespace orxonox
{
    /**
    @brief
        This class displays the shield status of the target enemy of it's owner.
    */
    class _OverlaysExport HUDEnemyShieldBar : public HUDShieldBar
    {
        public:
            HUDEnemyShieldBar(Context* context);
            virtual ~HUDEnemyShieldBar();

            void setConfigValues();
            virtual void tick(float dt) override;

            virtual void changedOwner() override;

        private:
            void updateTarget();

            ControllableEntity* owner_;
            bool useEnemyBar_;
    };
}
#endif /* _HUDEnemyShieldBar_H__ */
