/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      ...
 *
 */

#ifndef _PluginManager_H__
#define _PluginManager_H__

#include "core/CorePrereqs.h"

#include <map>
#include <string>
#include "util/Singleton.h"
#include "core/config/Configurable.h"

namespace orxonox
{
    class _CoreExport PluginManager : public Singleton<PluginManager>, public Configurable
    {
        friend class Singleton<PluginManager>;

        public:
            PluginManager();
            ~PluginManager();

            void setConfigValues();

            void findPlugins();

            void referencePlugin(const std::string& name);
            void dereferencePlugin(const std::string& name);

            // console commands
            void loadPlugin(const std::string& name);
            void unloadPlugin(const std::string& name);

        private:
            void changedConfigValue();

            std::map<std::string, Plugin*> plugins_;
            std::map<std::string, PluginReference*> references_; // references that were created by console command
            bool bMerelyDeactivatePlugins_;

            static PluginManager* singletonPtr_s;
    };
}

#endif /* _PluginManager_H__ */
