/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      ...
 *
 */

/**
    @file
    @ingroup Config ConfigFile
*/

#ifndef _ConfigFileEntryComment_H__
#define _ConfigFileEntryComment_H__

#include "core/CorePrereqs.h"

#include "ConfigFileEntry.h"

namespace orxonox
{
    ////////////////////////////
    // ConfigFileEntryComment //
    ////////////////////////////
    /**
        @brief This class represents a line in the config file which contains only a comment.
    */
    class _CoreExport ConfigFileEntryComment : public ConfigFileEntry
    {
        public:
            /// Constructor: Initializes the object.
            inline ConfigFileEntryComment(const std::string& comment) : comment_(comment) {}

            /// Destructor
            virtual inline ~ConfigFileEntryComment() = default;

            virtual inline const std::string& getName() const override
                { return this->comment_; }

            virtual inline void setComment(const std::string& comment) override
                { this->comment_ = comment; }

            virtual inline void setValue(const std::string& value) override
                {}
            virtual inline const std::string& getValue() const override
                { return BLANKSTRING; }

            virtual inline void setString(bool bString) override
                {}

            virtual inline const std::string& getFileEntry() const override
                { return this->comment_; }

        private:
            std::string comment_;   ///< The comment
    };
}

#endif /* _ConfigFileEntryComment_H__ */
