#ifndef _DialogueManager_H__
#define _DialogueManager_H__

#include "core/CoreIncludes.h"
#include "core/LuaState.h"
#include "core/GUIManager.h"
#include "core/class/Identifier.h"
#include "core/singleton/ScopedSingletonIncludes.h"
#include "network/Host.h"
#include "network/NetworkFunctionIncludes.h"
#include "util/Singleton.h"
#include <string>
#include <vector>
//#include "OrxonoxPrereqs.h"
#include "core/config/Configurable.h"
#include "core/XMLPort.h"
#include "core/EventIncludes.h"
#include "DialoguePrereqs.h"
#include "NextQuestion.h"




namespace orxonox //tolua_export

{//tolua_export
	class _OrxonoxExport DialogueManager //tolua_export
	: public Singleton<DialogueManager>
	{//tolua_export
		friend class Singleton<DialogueManager>;
	
		public:
		

		DialogueManager(); 
		

		static DialogueManager& getInstance() { return Singleton<DialogueManager>::getInstance(); } //tolua_export
		
		void setquestion(std::string question); //tolua_export
		std::string getquestion(void); //tolua_export
		
		void registerquestion(NextQuestion* nq);
		void setanswers1(std::string a1); //tolua_export
		void setanswers2(std::string a2); //tolua_export
		std::string getanswers1(void); //tolua_export
		std::string getanswers2(void); //tolua_export
		void a1clicked(void); //tolua_export
		void a2clicked(void); //tolua_export
		bool theEnd(); //tolua_export 
		void update(NextQuestion* nq);
		void clean(); //tolua_export
		void setCurrentQuestion(NextQuestion* q);

private:
	NextQuestion* currentQuestion;
	std::vector<NextQuestion*> allQuestions;
	std::string a1;
	std::string a2;
	std::string question;
	int depth = 0;
	static DialogueManager* singletonPtr_s;

	};//tolua_export
}//tolua_export
#endif