#ifndef _NextQuestion_H__
#define _NextQuestion_H__


//#include <vector>
#include <string>
#include "core/class/Identifier.h"
#include "OrxonoxPrereqs.h"
#include "core/XMLPort.h"
#include "core/EventIncludes.h"
#include "DialoguePrereqs.h"


namespace orxonox{
	class _OrxonoxExport NextQuestion : public BaseObject
	{
		
		//tolua_begin
		public:

		NextQuestion (Context* context); // tolua_export
		

		void setquestion(std::string question);
		std::string getquestion(void);


		bool addposQuestion(NextQuestion* nq);
		const NextQuestion* getposQuestion(unsigned int index) const;
 
		
		virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode);

		void setanswers1(std::string a1);
		void setanswers2(std::string a2);
		std::string getanswers1(void);
		std::string getanswers2(void);

		NextQuestion compare();
		

		//Event
		virtual void XMLEventPort(Element& xmlelement, XMLPort::Mode mode);
		bool execute(bool bTriggered, BaseObject* trigger);

		std::vector<NextQuestion*> possibleQuestions;
		std::vector<NextQuestion*> retposQues();
	private:
		std::string a1;
		std::string a2;
		


		std::string question;
		DialogueManager* m;

	};
	
}
#endif