/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

/**
    @file SOBQBlock.cc
    @brief If this QBlock is created, attachedToFigure_ is set to false. When the figure picks it up, the variable is set to true and the figure starts flying fast until the fuel is reduced to zero.
*/

#include "SOBQBlock.h"

#include "core/CoreIncludes.h"
#include "core/XMLPort.h"
#include "SOB.h"
#include "SOBMushroom.h"

namespace orxonox
{
    RegisterClass(SOBQBlock);

    SOBQBlock::SOBQBlock(Context* context) : SOBItem(context)
    {
        RegisterObject(SOBQBlock);
        used_ = false;
   
        // setPosition(Vector3(0,0,0));
        // setVelocity(Vector3(0,0,0));
        // setAcceleration(Vector3(0,0,0));
        // setProperties(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    SOBQBlock::~SOBQBlock()
    {

    }

   
    bool SOBQBlock::collidesAgainst(WorldEntity* otherObject, const btCollisionShape* ownCollisionShape, btManifoldPoint& contactPoint) {

        float v_z = otherObject->getVelocity().z;
        if (!used_ && v_z > 50.0) {
            used_ = true;

            for (WorldEntity* object : this->getAttachedObjects())
                object->setVisible(!object->isVisible());            

            SOB* SOBGame = orxonox_cast<SOB*>(getGametype());
            if (type_ == "Coin") {
                SOBGame->addCoin();
            }
            if (type_ == "Mushroom") {
                spawnMushroom();
            }

        }
        return true;
    }


    void SOBQBlock::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(SOBQBlock, XMLPort, xmlelement, mode);
        XMLPortParam(SOBQBlock, "type",     setType,     getType,     xmlelement, mode).defaultValues(false);


     }


     void SOBQBlock::spawnMushroom() {
        SOBCenterpoint* center_ = ((SOB*)getGametype())->center_;

         SOBMushroom* mush = new SOBMushroom(center_->getContext());
         Vector3 spawnpos = this->getWorldPosition();
         spawnpos.z += 0;

        if (mush != nullptr && center_ != nullptr)
        {
            mush->addTemplate("mushroom");
           


            //newBoots->addTemplate(center_->getBootsTemplate());
            mush->setPosition(spawnpos);
            //newBoots->setProperties(leftBoundary, rightBoundary, lowerBoundary, upperBoundary, xVelocity, zVelocity);
            //newBoots->setFigure(figure_);
            //center_->attach(newBoots);
        }
     }


}
