/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

/**
    @file SOBMushroom.h
    @brief Declaration of the SOBMushroom class.
    @ingroup SOB
*/

#ifndef _SOBMushroom_H__
#define _SOBMushroom_H__

#include "superorxobros/SOBPrereqs.h"
#include "worldentities/MovableEntity.h"


namespace orxonox
{
    class _SOBExport SOBMushroom : public MovableEntity
    {
        public:
            SOBMushroom(Context* context);
            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode) override;
            virtual void setFigure(SOBFigure* newFigure);
            virtual void touchFigure();
            virtual  bool collidesAgainst(WorldEntity* otherObject, const btCollisionShape* ownCollisionShape, btManifoldPoint& contactPoint) override;
            virtual void tick(float dt) override;

          
            bool attachedToFigure_;

            void setSpeed(const float speed)
                { this->speed_ = speed; }
            float getSpeed() const
                { return speed_; }

            bool hasCollided_;
        protected:
            float gravityAcceleration_;
            float speed_;
            WeakPtr<SOBFigure> figure_;
           
    };
}

#endif /* _SOBMushroom_H__ */
