/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

/**
    @file SOBMushroom.cc
    @brief All items in this minigame inherit from this class. Items can move around like platforms and enemies.
*/

#include "SOBMushroom.h"

#include "core/CoreIncludes.h"
#include "core/XMLPort.h"
#include "SOBFigure.h"
#include "util/Output.h"


namespace orxonox
{
    RegisterClass(SOBMushroom);

    SOBMushroom::SOBMushroom(Context* context) : MovableEntity(context)
    {
        RegisterObject(SOBMushroom);

        attachedToFigure_ = false;
        setAngularFactor(0.0);
        figure_ = nullptr;
        this->enableCollisionCallback();
        gravityAcceleration_ = 350.0;
        speed_ = 0.0;
        hasCollided_=false;
       
    }

    

    void SOBMushroom::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(SOBMushroom, XMLPort, xmlelement, mode);
        XMLPortParam(SOBMushroom, "speed", setSpeed, getSpeed, xmlelement, mode);


     }

   
    bool SOBMushroom::collidesAgainst(WorldEntity* otherObject, const btCollisionShape* ownCollisionShape, btManifoldPoint& contactPoint) {

//orxout() << "Watshc bum baem" << endl;
return true;
    }


    void SOBMushroom::setFigure(SOBFigure* newFigure)
    {
        figure_ = newFigure;
    }

    void SOBMushroom::touchFigure()
    {

    }

    void SOBMushroom::tick(float dt)
    {
        SUPER(SOBMushroom, tick, dt);

          Vector3 velocity = getVelocity();
        velocity.z -= gravityAcceleration_*dt;
        velocity.x = speed_;
        setVelocity(velocity);


    

}
}
