/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Florian Zinggeler
 *
 */

#ifndef _SOBHUDInfo_H__
#define _SOBHUDInfo_H__

#include "superorxobros/SOBPrereqs.h"

#include "tools/interfaces/Tickable.h"
#include "overlays/OverlayText.h"

namespace orxonox
{
    class _SOBExport SOBHUDInfo : public OverlayText, public Tickable
    {
        public:
            SOBHUDInfo(Context* context);

            virtual void tick(float dt) override;
            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode) override;
            virtual void changedOwner() override;

            inline void setType(std::string type)
                { this->type_ = type; }
            inline std::string getType() const
                { return this->type_; }
        

        private:
            SOB* SOBGame;
            std::string type_;
      
    };
}
#endif /* _SOBHUDInfo_H__ */
