/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Florian Zinggeler
 *
 */

#include "SOBHUDInfo.h"

#include "core/CoreIncludes.h"
#include "core/XMLPort.h"
#include "util/Convert.h"
#include "SOB.h"
#include <sstream>
#include <iomanip>



namespace orxonox
{
    RegisterClass(SOBHUDInfo);

    SOBHUDInfo::SOBHUDInfo(Context* context) : OverlayText(context)
    {
        RegisterObject(SOBHUDInfo);

        this->SOBGame = nullptr;
        
    }

    void SOBHUDInfo::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(SOBHUDInfo, XMLPort, xmlelement, mode);
        XMLPortParam(SOBHUDInfo, "type",     setType,     getType,     xmlelement, mode).defaultValues(false);


    }

    void SOBHUDInfo::tick(float dt)
    {
        SUPER(SOBHUDInfo, tick, dt);

        if (this->SOBGame)
        {
          
         // setPosition(Vector2(0.1, 0.65));
          if (this->type_ == "Coins") {
                // this->setCaption("Game ends in 30 seconds.\nPress (e)xit / (q)uit to go to the main menu.\nTo restart fly out of the screen!");
                    
                    
            std::stringstream ss;
            ss << "cc x " << std::setw(2) << std::setfill('0') << SOBGame->getCoins();
            std::string s = ss.str();

            this->setCaption(s);
            
          }
           if (this->type_ == "Points") {
            std::stringstream ss;
            ss << std::setw(6) << std::setfill('0') << SOBGame->getPoints();
            std::string s = ss.str();
            this->setCaption(s);
          }
          if (this->type_ == "Time") {
            std::stringstream ss;
            ss << SOBGame->getTimeLeft();
            std::string s = ss.str();
            this->setCaption(s);
          }
               


            //     const std::string& Level = multi_cast<std::string>(this->SOBGame->getLevel());
            //     if (this->SOBGame->lives <= 0)
            //     {
            //         setPosition(Vector2(0.1, 0.65));
            //         this->setCaption("Game ends in 30 seconds.\nPress (e)xit / (q)uit to go to the main menu.\nTo restart fly out of the screen!");
            //         setTextSize(0.05);
            //         this->SOBGame->bEndGame = true;
            //     }
            //     else if (this->SOBGame->bShowLevel)
            //     {
            //         setTextSize(0.1);
            //         setPosition(Vector2(0.3, 0.55));
            //         std::stringstream sstm;
            //         sstm << "Level " << Level;
            //         this->setCaption(sstm.str()); // + level
            //     }
            //     else
            //     {
            //         setTextSize(0.04);
            //         setPosition(Vector2(0.14, 0.055));
            //         this->setCaption(Level);
            //     }
            // ////////////
            //     const std::string& points = multi_cast<std::string>(this->SOBGame->getPoints());
            //     if (this->SOBGame->lives <= 0)
            //     {
            //         setTextSize(0.2);
            //         setPosition(Vector2(0.1, 0.25));
            //         this->setCaption("Final score:\n" + points);
            //         this->setColour(ColourValue(1, 0, 0, 1));
            //     }
            //     else
            //     {
            //         setTextSize(0.04);
            //         setPosition(Vector2(0.14, 0.1));
            //         this->setColour(ColourValue(1, 1, 1, 1));
            //         this->setCaption(points);
            //     }
            
            // /////////////
            //     int mult = this->SOBGame->getMultiplier();
            //     const std::string& Multiplier = "X " + multi_cast<std::string>(mult);
            //     this->setCaption(Multiplier);
            //     this->setColour(ColourValue(1, 0, 0, clamp(float(mult * 0.1), 0.0f, 1.0f)));
            //     this->setTextSize(clamp(float(mult * 0.1), 0.0f, 1.0f) * 0.01f + 0.04f);
            
        }
    }

    void SOBHUDInfo::changedOwner()
    {
        SUPER(SOBHUDInfo, changedOwner);

        if (this->getOwner() && this->getOwner()->getGametype())
        {
            this->SOBGame = orxonox_cast<SOB*>(this->getOwner()->getGametype());
        }
        else
        {
            this->SOBGame = nullptr;
        }
    }
}
