/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      ...
 *
 */

/**
    @file Pong.h
    @brief Declaration of the Pong class.
    @ingroup Pong
*/

#ifndef _SOB_H__
#define _SOB_H__

#include "superorxobros/SOBPrereqs.h"

#include "tools/Timer.h"

#include "gametypes/Deathmatch.h"
#include "SOBCenterpoint.h"

namespace orxonox
{


    class _SOBExport SOB : public Deathmatch
    {
    public:
            SOB(Context* context); //!< Constructor. Registers and initializes the object.
            virtual ~SOB(); //!< Destructor. Cleans up, if initialized.
            virtual void tick(float dt) override;


            void setCenterpoint(SOBCenterpoint* center)
            { this->center_ = center; }
            virtual void start() override;
            virtual void end() override;
            virtual void spawnPlayer(PlayerInfo* player) override;
            PlayerInfo* getPlayer() const;

            int getPoints() {
                return points_;
            }
            int getCoins() {
                return coins_;
            }
            void addCoin() {
                ++coins_;
                points_+=200;
            }
            void addMushroom() {
                points_+=1000;
            }
            int getTimeLeft() {
                return timeLeft_;
            }
            

           virtual void playerEntered(PlayerInfo* player) override
            {
                Gametype::playerEntered(player);
            }  


            WeakPtr<SOBCenterpoint> center_;

        protected:


            void cleanup(); //!< Cleans up the Gametype 
            WeakPtr<SOBFigure> figure_;
            WeakPtr<Camera> camera;
            int points_;
            int coins_;
            float timeLeft_;


        };
    }

#endif /* _Pong_H__ */
