/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      ...
 *
 */

/**
    @file Pong.cc
    @brief Implementation of the Pong class.
*/

#include "SOB.h"

#include "core/CoreIncludes.h"
#include "core/EventIncludes.h"
#include "core/command/Executor.h"
#include "core/config/ConfigValueIncludes.h"

#include "gamestates/GSLevel.h"
#include "chat/ChatManager.h"
#include "infos/PlayerInfo.h"

#include "SOBCenterpoint.h"

#include "SOBFigure.h"
#include "graphics/Camera.h"

namespace orxonox
{

    RegisterUnloadableClass(SOB);

    /**
    @brief
        Constructor. Registers and initializes the object.
    */
    SOB::SOB(Context* context) : Deathmatch(context)
    {
        RegisterObject(SOB);
        camera = nullptr;

        this->center_ = nullptr;
        figure_ = nullptr;
        setHUDTemplate("SOBHUD");
        coins_=0;
        points_=0;
        timeLeft_=400.0;

    }

    /**
    @brief
        Destructor. Cleans up, if initialized.
    */
    SOB::~SOB()
    {
        if (this->isInitialized())
            this->cleanup();
    }

    void SOB::cleanup()
    {
        camera = nullptr;
    }

        void SOB::start()
    {
        if (center_ != nullptr) // There needs to be a SOBCenterpoint, i.e. the area the game takes place.
        {
            if (figure_ == nullptr)
            {
                figure_ = new SOBFigure(center_->getContext());
                figure_->addTemplate(center_->getFigureTemplate());
               // figure_->InitializeAnimation(center_->getContext()); //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
            }

            center_->attach(figure_);
            figure_->setPosition(0, 0, 0);
        }
        else // If no centerpoint was specified, an error is thrown and the level is exited.
        {
            orxout(internal_error) << "SOB: No Centerpoint specified." << endl;
            GSLevel::startMainMenu();
            return;
        }

        // Call start for the parent class.
        Gametype::start();

        if (figure_ != nullptr)
        {
            camera = figure_->getCamera();
        }

    }

    void SOB::end()
    {
        cleanup();
        GSLevel::startMainMenu();

        Deathmatch::end();
    }

    void SOB::spawnPlayer(PlayerInfo* player)
    {
        assert(player);

        if (figure_->getPlayer() == nullptr)
        {
            player->startControl(figure_);
            players_[player].state_ = PlayerState::Alive;
        }
    }

    PlayerInfo* SOB::getPlayer() const
    {
        if (this->figure_ != nullptr)
        {
            return this->figure_->getPlayer();
        }
        else
        {
            return nullptr;
        }
    }

void SOB::tick(float dt)
    {
        SUPER(SOB, tick, dt);

        if (this->figure_ != nullptr && figure_->dead_)
            orxout() << "DEED" << endl;
       

       timeLeft_-=dt*2.5;
    }


}
