/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Florian Zinggeler
 *   Co-authors:
 *      ...
 *
 */

/**
    @file InvaderShip.h
    @brief Declaration of the InvaderShip class.
*/

#ifndef _Orxo_H__
#define _Orxo_H__

//#include "invader/InvaderPrereqs.h"

//#include "weapons/WeaponsPrereqs.h"
#include "worldentities/pawns/SpaceShip.h"

namespace orxonox
{
    class Orxo : public SpaceShip
    {
    public:
        Orxo(Context* context);

        virtual void tick(float dt) override;


            // overwrite for 2d movement
        virtual void moveFrontBack(const Vector2& value) override;
        virtual void moveRightLeft(const Vector2& value) override;

            // Starts or stops fireing
        virtual void boost(bool bBoost) override;

            //no rotation!
        virtual void rotateYaw(const Vector2& value) override{};
        virtual void rotatePitch(const Vector2& value) override{};
            //return to main menu if game has ended.
        virtual void rotateRoll(const Vector2& value) override;

        virtual void updateLevel();

        virtual inline bool collidesAgainst(WorldEntity* otherObject, const btCollisionShape* ownCollisionShape, btManifoldPoint& contactPoint) override;




      


    protected:
        virtual void death() override;
    private:
            //SOB* getGame();
            //WeakPtr<SOB> game;
        Camera* camera;
        float speed, damping, posforeward;
        float lastTimeFront, lastTimeLeft, lastTime;
        struct Velocity
        {
            float x;
            float y;
        } velocity, desiredVelocity;

           // WeakPtr<InvaderEnemy> lastEnemy;
            //WeakPtr<Projectile> lastShot;

    };
}

#endif /* _InvaderShip_H__ */
