#include "core/CoreIncludes.h"
#include "core/LuaState.h"
#include "core/GUIManager.h"
#include "core/class/Identifier.h"
#include "core/singleton/ScopedSingletonIncludes.h"
#include "network/Host.h"
#include "network/NetworkFunctionIncludes.h"
#include "DialoguePrereqs.h"
#include "util/Singleton.h"
#include <string>
#include <vector>
#include "OrxonoxPrereqs.h"
#include "core/config/Configurable.h"
#include "core/XMLPort.h"
#include "core/EventIncludes.h"

//tolua_begin
namespace orxonox
//tolua_end
{//toluaexport
	class _OrxonoxExport DialogueManager : public Singleton<DialogueManager>, public BaseObject
	{
		friend class Singleton<DialogueManager>;
		//tolua_begin
		public:

		DialogueManager(Context* context); // tolua_export
		

		static DialogueManager& getInstance() { return Singleton<DialogueManager>::getInstance(); } 
		
		virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode);

		void setquestion(std::string question);
		std::string getquestion(void);


		virtual void XMLEventPort(Element& xmlelement, XMLPort::Mode mode);
		bool execute(bool bTriggered, BaseObject* trigger);

	

			/*std::string setnpc(std::string npc);

			void setanswers(std::string option1, std::string option2, std::string option3);
			std::vector <std::string> getanswers(void);

			int getnumOptions();
			

			
			std::string npc;
			std::vector<std::string> options;
		//tolua_end
*/
private:
	std::string question;
	static DialogueManager* singletonPtr_s;

	};//toluaexport
}
