/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

#ifndef _SOBFigure_H__
#define _SOBFigure_H__

#include "superorxobros/SOBPrereqs.h"
#include "worldentities/ControllableEntity.h"

namespace orxonox
{
    class _SOBExport SOBFigure : public ControllableEntity
    {
        public:
            SOBFigure(Context* context); //!< Constructor. Registers and initializes the object.
            virtual ~SOBFigure() {}
            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode) override;
            virtual void tick(float dt) override;
            virtual void moveFrontBack(const Vector2& value) override; //!< Overloaded the function to steer the figure up and down.
            virtual void moveRightLeft(const Vector2& value) override; //!< Overloaded the function to steer the figure up and down.
            
          
            virtual void fired(unsigned int firemode) override;
            
            //virtual void CollisionWithEnemy(SOBEnemy* enemy);
            
            
   
          
            bool dead_;

          
        private:
            
            bool moveUpPressed_;
            bool moveDownPressed_;
            bool moveLeftPressed_;
            bool moveRightPressed_;
            bool firePressed_;
            float gravityAcceleration_;
            float timeSinceLastFire_;

           
            
           
    };
}

#endif /* _SOBFigure_H__ */
