/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

/**
    @file SOBFigure.cc
    @brief This class represents your figure when you play the minigame. Here the movement of the figure, activating items, ... are handled.
*/

#include "SOBFigure.h"

#include "core/CoreIncludes.h"
#include "core/XMLPort.h"
#include "graphics/Model.h"


namespace orxonox
{
    RegisterClass(SOBFigure);

    SOBFigure::SOBFigure(Context* context) : ControllableEntity(context)
    {
        RegisterObject(SOBFigure);

        // initialize variables
      
        moveUpPressed_ = false;
        moveDownPressed_ = false;
        moveLeftPressed_ = false;
        moveDownPressed_ = false;
        firePressed_ = false;
        timeSinceLastFire_ = 0.0;
  
        gravityAcceleration_ = 8.0;
       
        dead_ = false;
    }

    void SOBFigure::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(SOBFigure, XMLPort, xmlelement, mode);
  
    }

    void SOBFigure::tick(float dt)
    {
        SUPER(SOBFigure, tick, dt);

        if (hasLocalController())
        {
            timeSinceLastFire_ += dt;

            // Move up/down
            Vector3 velocity = getVelocity();
          
            
            
                velocity.z -= gravityAcceleration_;
            

       

            // Move left/right
            if (dead_ == false)
            {
                if (moveRightPressed_)
                    velocity.x = 75;
                else if (moveLeftPressed_)
                    velocity.x = 75;
                else
                    velocity.x = 0;
            }
            else
            {
                velocity.x = 0.0;
            }

           

            setVelocity(velocity);


        
        }

        // Move through the left and right screen boundaries
        
        //setPosition(position);

        // Reset key variables
        moveUpPressed_ = false;
        moveDownPressed_ = false;
        moveLeftPressed_ = false;
        moveDownPressed_ = false;
     
    }

   

    

   /* void SOBFigure::CollisionWithEnemy(SOBEnemy* enemy)
    {
        if (rocketActive_ == nullptr && propellerActive_ == nullptr && shieldActive_ == nullptr)
        {
            dead_ = true;
        }
    }*/

   


    

    void SOBFigure::moveFrontBack(const Vector2& value)
    {
        if (value.x > 0)
        {
            moveUpPressed_ = true;
            moveDownPressed_ = false;
        }
        else
        {
            moveUpPressed_ = false;
            moveDownPressed_ = true;
        }
    }

    void SOBFigure::moveRightLeft(const Vector2& value)
    {
        if (value.x > 0)
        {
            moveLeftPressed_ = false;
            moveRightPressed_ = true;
        }
        else
        {
            moveLeftPressed_ = true;
            moveRightPressed_ = false;
        }
    }

    

 

    void SOBFigure::fired(unsigned int firemode)
    {
        firePressed_ = true;
    }
}
