/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      ...
 *
 */

/**
    @file PongCenterpoint.cc
    @brief Implementation of the PongCenterpoint class.
*/

#include "SOBCenterpoint.h"

#include "core/CoreIncludes.h"
#include "core/XMLPort.h"

#include "SOB.h"

namespace orxonox
{
    RegisterClass(SOBCenterpoint);

    /**
    @brief
        Constructor. Registers and initializes the object and checks whether the gametype is actually Pong.
    */
    SOBCenterpoint::SOBCenterpoint(Context* context) : StaticEntity(context)
    {
        RegisterObject(SOBCenterpoint);


        this->checkGametype();
    }

    /**
    @brief
        Method to create a PongCenterpoint through XML.
    */
    void SOBCenterpoint::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(SOBCenterpoint, XMLPort, xmlelement, mode);

        //XMLPortParam(SOBCenterpoint, "dimension", setFieldDimension, getFieldDimension, xmlelement, mode);
        //XMLPortParam(SOBCenterpoint, "balltemplate", setBalltemplate, getBalltemplate, xmlelement, mode);
       // XMLPortParam(SOBCenterpoint, "battemplate", setBattemplate, getBattemplate, xmlelement, mode);
       // XMLPortParam(SOBCenterpoint, "ballspeed", setBallSpeed, getBallSpeed, xmlelement, mode);
       // XMLPortParam(SOBCenterpoint, "ballaccfactor", setBallAccelerationFactor, getBallAccelerationFactor, xmlelement, mode);
       // XMLPortParam(SOBCenterpoint, "batspeed", setBatSpeed, getBatSpeed, xmlelement, mode);
       // XMLPortParam(SOBCenterpoint, "batlength", setBatLength, getBatLength, xmlelement, mode);
    }

    /**
    @brief
        Checks whether the gametype is Pong and if it is, sets its centerpoint.
    */
    void SOBCenterpoint::checkGametype()
    {
        if (this->getGametype() != nullptr && this->getGametype()->isA(Class(SOB)))
        {
            SOB* SOBGametype = orxonox_cast<SOB*>(this->getGametype());
            SOBGametype->setCenterpoint(this);
        }
    }
}
