-- HighscoreMenu.lua

local P = createMenuSheet("HighscoreMenu")

P.highscoreList = {}
P.tabList = {}
P.linesList = {}
P.levelList = {}


P.imageHeight = 50

function P.onLoad()
	P.createLevelList()    
end

function P.onShow()
	
	-- reset tables
	P.highscoreList = {}
	P.tabList = {}
	P.linesList = {}

	-- fetch save scores and write it into the list
	for i=orxonox.Highscore:getInstance():getNumberOfHighscores()-1,0,-1 do
		table.insert(P.highscoreList, orxonox.Highscore:getInstance():getHighscore(i))
	
	end
	
	-- read minigames out of the levelList
    for k,v in pairs(P.levelList) do
        if(v:getName() ~= "Hover level" and v:getName() ~= "Pong") then   -- hover and pong dont contain relevant scores
            P.createFilterTab(v:getName(), v:getName())
        end
    end
  
end
function P.onHide()

	-- delete old windows to reload them on show
	local tabControl = winMgr:getWindow("orxonox/HighscoreTabControl")
	for k,v in pairs(P.tabList) do
        	local default = winMgr:getWindow(v)
            tabControl:removeChildWindow(default)
        	winMgr:destroyWindow(default)
    end
end
function P.createLevelList()
    P.levelList = {}
    local size = orxonox.LevelManager:getInstance():getNumberOfLevels()
    local index = 0
    local level = nil
    while index < size do
        level = orxonox.LevelManager:getInstance():getAvailableLevelListItem(index)
        if (level ~= nil and level:getXMLFilename() ~= "_temp.oxw" and level:hasTag("minigame")) then
            table.insert(P.levelList, level)
        end
        index = index + 1
    end
end
function P.createFilterTab(name, tag)
    -- create unique tab window name
    local tabName = "orxonox/HighscoreLevelTab"
    if tag ~= nil then
        tabName = tabName..tag
    end

    table.insert(P.tabList, tabName)
    -- create new tab window with desired name
	local default = (winMgr:createWindow("DefaultWindow", tabName))
    default:setText(name)
    default:setProperty("UnifiedMaxSize", "{{1,0},{1,0}}")
    default:setProperty("UnifiedAreaRect", "{{0,0},{0,0},{1,0},{1,0}}")
    local pane = winMgr:createWindow("MenuWidgets/ScrollablePane", tabName .. "pane") 
    pane:setSize(CEGUI.UVector2(CEGUI.UDim(1,0),CEGUI.UDim(1,0)))
    default:addChildWindow(pane)

   
    local offset = 2
    for k,v in pairs(P.highscoreList) do
    	-- split the score ("Playername./.game./.score")
    	local splitlist = P.Split(v,"./.")
    	if(splitlist[2] == name)then  
    		local line = P.createPickupEntry(tabName .. k,k,tag)
       	 	table.insert(P.linesList, line)
        	line:setYPosition(CEGUI.UDim(0,offset))
        	offset = offset + line:getHeight():asAbsolute(1)+2
        	pane:addChildWindow(line)	
    	end
        
    end

	local tabControl = winMgr:getWindow("orxonox/HighscoreTabControl")
	tabControl:addChildWindow(default)
 

    
end
function P.createPickupEntry(parent,k,tag)
   
    local name = "orxonox/HiscoreEntry" .. parent
    local splitlist = P.Split(P.highscoreList[k],"./.")
    local item = winMgr:createWindow("DefaultWindow", name)
    item:setSize(CEGUI.UVector2(CEGUI.UDim(1, 0), CEGUI.UDim(0, P.imageHeight)))
    item:setPosition(CEGUI.UVector2(CEGUI.UDim(0, 0), CEGUI.UDim(0, 0)))

    local player = winMgr:createWindow("MenuWidgets/StaticText", name .. "/Player")
    player:setText(splitlist[1])
    player:setPosition(CEGUI.UVector2(CEGUI.UDim(0.005,0), CEGUI.UDim(0,0)))
    player:setSize(CEGUI.UVector2(CEGUI.UDim(0.49, 0), CEGUI.UDim(0, P.imageHeight)))
    
    item:addChildWindow(player)
    	
    local score = winMgr:createWindow("MenuWidgets/StaticText", name .. "/Score")
    score:setText(splitlist[3])
    score:setPosition(CEGUI.UVector2(CEGUI.UDim(0.5,0), CEGUI.UDim(0,0)))
    score:setSize(CEGUI.UVector2(CEGUI.UDim(0.495, 0), CEGUI.UDim(0, P.imageHeight)))
    
    item:addChildWindow(score)

    return item
end
function P.HighscoreGetSelectedLevel()
    -- choose the active listbox
    local tabControl = CEGUI.toTabControl(winMgr:getWindow("orxonox/HighscoreTabControl"))
    local listbox = CEGUI.toListbox(tabControl:getTabContentsAtIndex(tabControl:getSelectedTabIndex()))
    local choice = listbox:getFirstSelectedItem()
    if choice ~= nil then
        -- get the right tab and the right index
        local tabIndexes = P.activeTabIndexes[tabControl:getSelectedTabIndex()+1]
        local index = tabIndexes[listbox:getItemIndex(choice)+1]
        return P.levelList[index]
    else
        return nil
    end
end
function P.Split(str, delim, maxNb)
    -- Eliminate bad cases...
    if string.find(str, delim) == nil then
        return { str }
    end
    if maxNb == nil or maxNb < 1 then
        maxNb = 0    -- No limit
    end
    local result = {}
    local pat = "(.-)" .. delim .. "()"
    local nb = 0
    local lastPos
    for part, pos in string.gfind(str, pat) do
        nb = nb + 1
        result[nb] = part
        lastPos = pos
        if nb == maxNb then break end
    end
    -- Handle the last field
    if nb ~= maxNb then
        result[nb + 1] = string.sub(str, lastPos)
    end
    return result
end



function P.HighscoreBackButton_clicked(e)
    hideMenuSheet(P.name)
end

return P

