#include "Waypoint.h"
#include <OgreSceneNode.h>
#include <BulletDynamics/Dynamics/btRigidBody.h>
#include "util/OrxAssert.h"
#include "core/CoreIncludes.h"
#include "core/XMLPort.h"
#include "WaypointGroup.h"
#include "core/EventIncludes.h"


namespace orxonox


{
    RegisterClass(Waypoint);

    Waypoint::Waypoint(Context* context) : StaticEntity(context)
    {
        RegisterObject(Waypoint);
        model = new Model(this->getContext());
        model->setMeshSource("cube.mesh");  // Name of the arrow file for now bottle
        this->attach(model);
        model->setScale(0);
        //model->setOrientation(Vector3(0,0,-1));
        model->setPosition(Vector3(0.0,0.0,0.0));        // this is wrong, it has to be triggered
        waypoint_actived = false;
        distancetrigger = new DistanceTrigger(this->getContext());
        distancetrigger->setDistance(100);
        distancetrigger->addTarget("Pawn");
        distancetrigger->setStayActive(false);
        this->addEventSource(distancetrigger, "activate");
        this->attach(distancetrigger);
    }

    Waypoint::~Waypoint()
    {
    }


    void Waypoint::activate(){
        orxout() << "activate function" << endl;
        ///++order;
        waypointgroup->activateNext();
    }


     //WorldEntity::setDirection
     //WorldEntity::getPosition()
     //setOrientation()


    void Waypoint::XMLEventPort(Element& xmlelement, XMLPort::Mode mode){
        SUPER(Waypoint, XMLEventPort, xmlelement, mode); // From the SpaceShip.cc file
        //XMLPortParam(Waypoint, "order", setOrder, getOrder, xmlelement, mode);
        XMLPortEventState(Waypoint, BaseObject, "activate", activate, xmlelement, mode);

    }


}
