

#ifndef _HUDDialogue_H__
#define _HUDDialogue_H__

#include "overlays/OverlaysPrereqs.h"

#include <map>
#include <string>

#include "util/OgreForwardRefs.h"
#include "overlays/OrxonoxOverlay.h"
#include "tools/Timer.h"

namespace orxonox
{
	class _OverlaysExport HUDDialogue : public OrxonoxOverlay
    {
    	public:
            HUDDialogue(Context* context); //!< Default Constructor.
            virtual ~HUDDialogue(); //!< Destructor.

            /**
            @brief Sets the active picture.
            */
            virtual void updateTarget(std::string portrait);
            /**
            @brief Sets the picture to invivsible when Dialogue is over.
            */
            virtual void invisible();

      private:
      			Ogre::PanelOverlayElement* overlayElementIcon_;

      			Timer portraitTimer; //!< The Timer which is used to set the picture back to invisible.
    };
}
#endif