
#include "Dialogue.h"
#include "core/CoreIncludes.h"
#include "core/EventIncludes.h"
#include "core/XMLPort.h"

#include "overlays/hud/HUDDialogue.h"

#include "NotificationDispatcher.h"

namespace orxonox{
	
	RegisterClass(Dialogue);

    /**
    @brief
        Default Constructor. Registers the object and initializes variables.
    */
	Dialogue::Dialogue(Context* context):NotificationDispatcher(context){
		RegisterObject(Dialogue);

		this->setSender("dialogue");

        this->setSyncMode(ObjectDirection::None);
	}
    /**
    @brief
        Destructor.
    */
	Dialogue::~Dialogue()
    {

    }
    /**
    @brief
        Method for creating a Dialogue object through XML.
    */
    void Dialogue::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(Dialogue, XMLPort, xmlelement, mode);

        XMLPortParam(Dialogue, "speaker", setSpeaker, getSpeaker, xmlelement, mode);
        XMLPortParam(Dialogue, "message", setMessage, getMessage, xmlelement, mode);
        XMLPortParam(Dialogue, "portrait", setPortrait, getPortrait, xmlelement, mode);
        
    }
    /**
    @brief
        Passes the name of the picture over to the HUDDialogue class
    */
    void Dialogue::update()
    {    
       for(HUDDialogue* huddialogue : ObjectList<HUDDialogue>())
                       huddialogue->updateTarget(portrait_);
    }
    /**
        @brief Creates the notification message,Pconsisting of a speaker and a message, that should be sent upon the Dialgue triggering.
        @return Returns the notification message.
    */
    const std::string& Dialogue::createNotificationMessage(void)
                { 	
                	dialogue_ = speaker_ + ": " + message_;
                    this->update();
                	return this->dialogue_ ;
                }
}