

#include "HUDDialogue.h"

#include "core/XMLPort.h"

#include <OgreCamera.h>
#include <OgreFontManager.h>
#include <OgreOverlayManager.h>
#include <OgreTextAreaOverlayElement.h>
#include <OgrePanelOverlayElement.h>
#include "core/CoreIncludes.h"

namespace orxonox
{

	RegisterClass (HUDDialogue);
	/**
    @brief
        Default Constructor. Registers the object and initializes variables.
    */
	HUDDialogue::HUDDialogue(Context* context) :
    OrxonoxOverlay(context)
    {
        RegisterObject(HUDDialogue);
	}   
	/**
	@brief
		Updates the picture to the picture which was declared in the Dialogue class and sets a timer to set the picture on invisible again.
	*/  
    void HUDDialogue::updateTarget(std::string portrait)
    {
    	overlayElementIcon_ = static_cast<Ogre::PanelOverlayElement* >(Ogre::OverlayManager::getSingleton().createOverlayElement("Panel", "Dialogue" + getUniqueNumberString()));
        overlayElementIcon_->setPosition(0.0f,0.0f);
        overlayElementIcon_->setDimensions(1.0f,1.0f);
        this->background_->addChild(overlayElementIcon_);     

    	overlayElementIcon_->setMaterialName(portrait);
    	this->setVisible(true);
    	portraitTimer.setTimer(2.9f,false,createExecutor(createFunctor(&HUDDialogue::invisible, this)));
    }
    /**
    @brief
    	Sets the picture back to invisible again.
    */
    void HUDDialogue::invisible()
    {
    	this->setVisible(false);
    	Ogre::OverlayManager::getSingleton().destroyOverlayElement(this->overlayElementIcon_);
    }
    /**
    @brief
    	Default Destructor.
    */
	HUDDialogue::~HUDDialogue()
	{


	}
}