
#ifndef _Dialogue_H__
#define _Dialogue_H__
#include <string>	
//#include "core/BaseObject.h"

#include "notifications/NotificationsPrereqs.h"

#include "notifications/NotificationDispatcher.h"

namespace orxonox{

	/**
    @brief
        The Dialogue class enables the sending of (in XML) predefined Notifications upon some kind of triggering event.

        In use it would like this:
        @code
        <Dialogue message="some message..." speaker="speaker" portrait="Orxonox/some_file">
            <events>
                <trigger>
                    <PlayerTrigger />
                </trigger>
            </events>
        </Dialogue>
        @endcode
        For more information on what can be used for @code <PlayerTrigger /> @endcode see the @ref orxonox::NotificationDispatcher "NotificationDispatcher" documentation.
		For more information about the Dialogue class take a look at the Notifications entry in the wiki.
		*/

class _NotificationsExport Dialogue: public NotificationDispatcher{

	public:
            Dialogue(Context* context); //!< Default Constructor.
            virtual ~Dialogue(); //!< Destructor.

            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode); //!< Method for creating a Dialogue object through XML.

            /**
            @brief Get the message, that is displayed.
            @return Returns the message, that is displayed.
            */
            const std::string& getMessage(void)
                	{ return this->message_; }
            /**
            @brief Get the name of the speaker.
            @return Returns the name of the speaker.
            */
         	const std::string& getSpeaker(void)
            		{return this->speaker_;}
            /**
            @brief Get the name of the file of the picture
            @return Returns the name of the file.
            */
            const std::string& getPortrait(void)
            		{ return this->portrait_;}

    protected:
    	/**
            @brief Creates the notification message that should be sent upon the Dialgue triggering.
            @return Returns the notification message.
            */
    	virtual const std::string& createNotificationMessage(void);
    	/**
    		@brief Updates the picture that is displayed by passing the name of the picture over to the HUDDialogue class.
    		*/
        virtual void update(void);
       	
    private:
    		std::string message_; //!< The message.
    		std::string speaker_; //!< The name of the speaker.
    		std::string dialogue_; //!< The speaker and the message that is displayed.
    		std::string portrait_; //!< The name of the file.

    		/**
    		@brief Sets the name of the speaker.
    		@param speaker The name of the speaker.
    		*/
    		void setSpeaker(const std::string& speaker)
            	{ this->speaker_ = speaker;}
            /**
            @brief Sets the message that is to be displayed.
            @param message The message to be displayed.
            */
    		void setMessage(const std::string& message)
                { this->message_ = message; }
            /**
            @brief Sets the name of the file of the picture.
            @param portrait Name of the file which is used.
            */
            void setPortrait(const std::string& portrait)
            	{ this->portrait_ = portrait;}
        } ;       
}

#endif 