#include "Waypointarrow.h"

#include <OgreSceneNode.h>
#include <BulletDynamics/Dynamics/btRigidBody.h>
#include "util/OrxAssert.h"
#include "core/CoreIncludes.h"

namespace orxonox
{
    RegisterClass(Waypointarrow);

    Waypointarrow::Waypointarrow(Context* context) : StaticEntity(context)
    {
        RegisterObject(Waypointarrow);
        model = new Model(this->getContext());
        model->setMeshSource("cokebottle.mesh");  // Name of the arrow file for now bottle
        this->attach(model);
        model->setScale(3);
       // model->setOrientation(Vector3(0,0,-1));
        model->setPosition(Vector3(0,15,0));
        waypoints_ = nullptr;
        
    }

    Waypointarrow::~Waypointarrow()
    {
    }

   /*  
    Waypoint* WaypointGroup::getActive(){
          for (Waypoint* object : this->waypoints_){
            if(!(object->waypoint_actived)){
                object->enable_waypoint();
                return object;
            }
        }
    }


    void tick::getActive
*/


    WaypointGroup* Waypointarrow::getWaypointgroup()
    {
        if (waypoints_ == nullptr){

            for (WaypointGroup* group : ObjectList<WaypointGroup>())
                waypoints_ = group;
        
        }

        return waypoints_;
    }




    void Waypointarrow::tick(float dt){
     
        if (getWaypointgroup() == nullptr){
                    orxout() << "Second" << endl;

            return;
        }     
               
        waypoints_ = getWaypointgroup();
               
        waypoint = waypoints_->getActive();
                       
        Vector3 waypoint_position = waypoint->getWorldPosition();
     
        orxout() << "dsfsf" << waypoint_position.x << endl;
        model->lookAt(waypoint_position - this->getWorldPosition());

        
    }

    void Waypointarrow::XMLPort(Element& xmlelement, XMLPort::Mode mode){
        SUPER(Waypointarrow, XMLPort, xmlelement, mode); // From the SpaceShip.cc file
        
        //XMLPortParamTemplate(WorldEntity, "orientation", setOrientation, getOrientation, xmlelement, mode, Vector3)

        //XMLPortObject(SpaceShip, Engine, "engines", addEngine, getEngine, xmlelement, mode); // TRY ADDING THE WAYPOINT ARROW LIKE AN ENGINE
 

    }


}
