

#ifndef _WaypointGroup_H__
#define _WaypointGroup_H__

#include "OrxonoxPrereqs.h"
#include "worldentities/StaticEntity.h"
#include "graphics/Model.h"
#include "objects/triggers/DistanceTrigger.h"

#include <map>
#include <string>

#include "core/CoreIncludes.h"
#include "util/OgreForwardRefs.h"
#include "Waypoint.h"

namespace orxonox
{
    /**
    @brief
        The StaticEntity is the simplest derivative of the @ref orxonox::WorldEntity class. This means all StaticEntity instances also have
        a position in space, a mass, a scale, a frication, ... because every StaticEntity is a WorldEntity. You can attach StaticEntities to eachother ike @ref orxonox::WorldEntity WorldEntities.

        In contrast to the MobileEntity the StaticEntity cannot move with respect to the parent to which it is attached. That's why
        it is called StaticEntity. It will keep the same position (always with respect to its parent) forever unless you call the
        function @see setPosition to changee it.

        A StaticEntity can only have the collisition type WorldEntity::None or WorldEntity::Static. The collsion types WorldEntity::Dynamic and WorldEntity::Kinematic are illegal.
    */

    class _OrxonoxExport WaypointGroup : public StaticEntity {
        
        public:

            WaypointGroup(Context* context);
            virtual ~WaypointGroup();


            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode) override;

        //Waypoint* getWaypoint();
        Waypoint* getWaypoint(unsigned int index);
        void setWaypoint(Waypoint* object);


        Waypoint* getActive();
          

        Waypoint* activateNext();

           

            


        private:
    
            //virtual bool isCollisionTypeLegal(CollisionType type) const override;
         
        std::set<Waypoint*> waypoints_;
        Waypoint* activeWaypoint;

            // network callbacks
    };
}

#endif /* _Waypoint_H__ */
