/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Patrick Wintermeyer
 *   Co-authors:
 *      ...
 *
 */

#include <vector>
#include <string>

#include "core/CoreIncludes.h"
#include "core/XMLPort.h"
#include "util/Convert.h"
#include "core/class/Super.h"
#include "HUDPickupSystem.h"
#include "pickup/Pickup.h"
#include "HUDPickupItem.h"

namespace orxonox
{
    RegisterClass(HUDPickupSystem);

    HUDPickupSystem::HUDPickupSystem(Context* context) : OrxonoxOverlay(context)
    {
        RegisterObject(HUDPickupSystem);

        overlayElement_ = static_cast<Ogre::PanelOverlayElement* >(Ogre::OverlayManager::getSingleton().createOverlayElement("Panel", "HUDPickupSystem" + getUniqueNumberString()));
        overlayElement_->setMaterialName("PickupBar");
        overlayElement_->setPosition(0.0f,0.0f);
        overlayElement_->setDimensions(0.70f,0.15f);
        orxout() << "hello here is the HUDPickupSystem" << endl;
        this->background_->addChild(overlayElement_);

    }

    HUDPickupSystem::~HUDPickupSystem()
    {
        if (this->isInitialized())
        {
            //TODO: Destroy me
        }
    }

   //TODO: XMLPort

    void HUDPickupSystem::updatePickupList(std::vector<WeakPtr<Pickup>> picks)
    {
        for(Pickup* p : picks)
        {
            HUDPickupItem* item = new HUDPickupItem(this->getContext());
            item->initializeMaterial(p->getRepresentationName());
        }
    }

    void HUDPickupSystem::createPickupList()
    {
     
    }      

    void HUDPickupSystem::destroyAll()
    {
        
    }
}
