
#ifndef _Dialogue_H__
#define _Dialogue_H__
#include <string>	
//#include "core/BaseObject.h"

#include "notifications/NotificationsPrereqs.h"

#include "notifications/NotificationDispatcher.h"

namespace orxonox{

class _NotificationsExport Dialogue: public NotificationDispatcher{

	public:
            Dialogue(Context* context); //!< Default Constructor.
            virtual ~Dialogue(); //!< Destructor.

            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode);

            const std::string& getMessage(void)
                { return this->message_; }
         	const std::string& getSpeaker(void)
            		{return this->speaker_;}
    protected:
    	virtual const std::string& createNotificationMessage(void);
                
       	
    private:
    		std::string message_;
    		std::string speaker_;
    		std::string dialogue_;

    		void setSpeaker(const std::string& speaker)
            	{ this->speaker_ = speaker;}
    		void setMessage(const std::string& message)
                { this->message_ = message; }
        } ;       

}

#endif 