/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Gani Aliguzhinov
 *   Co-authors:
 *      ...
 *
 */

#ifndef _WingmanController_H__
#define _WingmanController_H__


#include "controllers/ActionpointController.h"


namespace orxonox
{
    /**
        @note
        ActionpointController will not work, if there is no MasterController in the level!
        All the demos are in a file called AITest.oxw. In the menu look for New AI Testing Level.
    */
    class _OrxonoxExport WingmanController : public ActionpointController
    {
        public:
            //----[language demanded functions]----
                WingmanController(Context* context);

                virtual ~WingmanController();
            //----[/language demanded functions]----
            
            //----[orxonox demanded functions]----
                virtual bool hasWingman() override
                    { return false; }
                virtual bool hasFollower() override
                    { return false; }
            //----[/orxonox demanded functions]----

            //----[own functions]----
               ActionpointController* findNewLeader();
            //----[/own functions]----

        protected:
            //----action must only be managed by this----
                virtual void action() override; //<! action() is called in regular intervals managing the bot's behaviour.
                Vector3 getFormationPosition ();
                void keepFormation();
                
        private:
            //----private variables-----
                WeakPtr<ActionpointController> myLeader_;
                bool bFirstAction_;


    };
}

#endif /* _WingmanController_H__ */
