/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Gani Aliguzhinov
 *   Co-authors:
 *      Dominik Solenicki
 *
 */

#ifndef _FlyingController_H__
#define _FlyingController_H__


#include "controllers/CommonController.h"

namespace orxonox
{   
    /**
    @brief
        FlyingController stores all the flying methods and member variables of AI.
    */

    //Formation mode for the divisions
    enum class FormationMode
    {
        FINGER4, DIAMOND, WALL
    };

    class _OrxonoxExport FlyingController : public CommonController
    {

        public:
            static const float SPEED;              //<! ship's speed
            static const float ROTATEFACTOR;       //<! ship's rotation factor
 
            FlyingController(Context* context);
            virtual ~FlyingController();
            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode) override;

            void setSpread (int spread)                         //<! spread is a multiplier for formation flight, should be bigger than 100
                { this->spread_ = spread; }
            int getSpread () const                              
                { return this->spread_; }

            void setFormationModeXML(const std::string& val);
            std::string getFormationModeXML() const;

            void setFormationMode(FormationMode val)
                { this->formationMode_ = val; }
            FormationMode getFormationMode() const
                { return this->formationMode_; }
            bool bCopyOrientation_;                             //<! set to true by default, MasterController sets it in its tick(),
                                                                //<! if true, this will set its leader orientation as target orientation in action()
        protected:
            void stopMoving();                                  //<! don't call moveToTargetPosition() in tick, call lookAtTarget() from FightingController instead

            void moveToPosition(const Vector3& target, float dt);   //<! move towards a vector
            void moveToTargetPosition(float dt);                    //<! move to the preset position. Don't mix with positionOfTarget!

            void copyOrientation(const Quaternion& orient, float dt);   //<! roll to have same roll as orient
            void copyTargetOrientation(float dt);                       //<! roll to have a preset orient

            void setTargetPosition(const Vector3& target);              //<! preset a Vector to fly to
            void setTargetOrientation(const Quaternion& orient);        //<! preset a desired orientation
            void setTargetOrientation(ControllableEntity* target);      //<! preset a desired orientation
            virtual void boostControl();                                //<! boost if you can
            void keepFormation (const ControllableEntity* leaderEntity, 
                                Vector3& targetRelativePosition);   //<! preset targetPosition, so that 
                                                                    //<! this stays in a certain position relative to leader      
            
            FormationMode formationMode_;
          
            float rotationProgress_;    //<! for slerping 
            bool bHasTargetPosition_;
            Vector3 targetPosition_;    //<! vector to fly to
            bool bHasTargetOrientation_;
            Quaternion targetOrientation_;  //<! orientation to take
            int spread_;                //<! spread is a multiplier for formation flight, should be bigger than 100
            int tolerance_;             //<! if this ship is tolerance_ away from targetPosition_, ship decides that it finished moving
    };
}

#endif /* _FlyingController_H__ */
