/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

/**
    @file FlameGun.h
    @brief Definition of the FlameGun class.
*/

#ifndef _FlameGun_H__
#define _FlameGun_H__

#include "weapons/WeaponsPrereqs.h"
#include "weaponsystem/WeaponMode.h"

namespace orxonox
{

    /**
    @brief
        A WeaponMode that fires burning projectiles.
    @author
        Fabien Vultier
    @ingroup WeaponsWeaponModes
    */
    class _WeaponsExport FlameGun : public WeaponMode
    {
        public:
            FlameGun(Context* context);
            virtual ~FlameGun();

            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode) override;
            virtual void fire() override;

            inline void setLifetime(float lifetime)
                { this->lifetime_ = lifetime; }
            inline float getLifetime() const
                { return this->lifetime_; }

       private:
            float speed_; //The speed of the fired projectile.
            float lifetime_; //The lifetime of the fired projectile.
            float sideAcceleration_;

            static const int PROJECTILES_PER_FIRE;
    };
}

#endif /* _FlameGun_H__ */
