/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

/**
    @file MunitionContainer.cc
    @brief Implementation of the MunitionContainer class. This class is only used by the MunitionPickup class to defines  how much munition of what type the pickup contains.
*/

#include "MunitionContainer.h"

#include <sstream>
#include "core/CoreIncludes.h"
#include "core/XMLPort.h"

namespace orxonox
{
    RegisterClass(MunitionContainer);

    /**
    @brief
        Constructor. Registers the object and initializes the member variables.
    */
    MunitionContainer::MunitionContainer(Context* context) : BaseObject(context)
    {
        RegisterObject(MunitionContainer);

        this->munitionName_ = "";
        this->munitionAmount_ = 1;
        this->magazinesAmount_ = 1;
    }

    /**
    @brief
        Destructor.
    */
    MunitionContainer::~MunitionContainer()
    {
    }    

    /**
    @brief
        Method for creating a MunitionContainer object through XML.
    */
    void MunitionContainer::XMLPort(Element& xmlelement, orxonox::XMLPort::Mode mode)
    {
        SUPER(MunitionContainer, XMLPort, xmlelement, mode);

        XMLPortParam(MunitionContainer, "munitiontype", setMunitionName, getMunitionName, xmlelement, mode).defaultValues("LaserMunition");
        XMLPortParam(MunitionContainer, "munitionamount", setMunitionAmount, getMunitionAmount, xmlelement, mode).defaultValues(1);
        XMLPortParam(MunitionContainer, "magazinesamount", setMagazinesAmount, getMagazinesAmount, xmlelement, mode).defaultValues(0);
    }

    void MunitionContainer::setMunitionName(const std::string& munitionName)
    {
        Identifier* identifier = ClassByString(munitionName);
        if (identifier)
        {
            this->munitionName_ = munitionName;
            this->munitionType_ = identifier;
        }
        else
        {
            this->munitionName_ = "";            
            orxout(internal_warning) << "Invalid munition class defined in MunitionContainer." << endl;
        }
    }   

    void MunitionContainer::setMunitionAmount(int munitionAmount)
    {
        if (munitionAmount > 0)
        {
            munitionAmount_ = munitionAmount;
        }
        else
        {
            munitionAmount_ = 0;
        }
    }

    void MunitionContainer::setMagazinesAmount(int magazinesAmount)
    {
        if (magazinesAmount > 0)
        {
            magazinesAmount_ = magazinesAmount;
        }
        else
        {
            magazinesAmount_ = 0;
        }
    }         
}

