/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

#include "HUDShieldBar.h"

#include "core/CoreIncludes.h"
#include "worldentities/pawns/Pawn.h"

namespace orxonox
{
    RegisterClass(HUDShieldBar);

    HUDShieldBar::HUDShieldBar(Context* context)
        : HUDBar(context)
    {
        RegisterObject(HUDShieldBar);

        this->owner_ = nullptr;
    }

    HUDShieldBar::~HUDShieldBar()
    {
    }

    void HUDShieldBar::tick(float dt)
    {
        SUPER(HUDShieldBar, tick, dt);

        if (this->owner_)
        {
            float maxShieldHealth = this->owner_->getMaxShieldHealth();
            float shieldHealth = this->owner_->getShieldHealth();

            if (maxShieldHealth > 0.0f)
            {
                this->setValue(shieldHealth/maxShieldHealth);
            }
            else
            {
                this->setValue(0.0f);
            }
        }
        else
        {
            this->setValue(0.0f);
        }
    }

    void HUDShieldBar::changedOwner()
    {
        SUPER(HUDShieldBar, changedOwner);

        this->owner_ = orxonox_cast<Pawn*>(this->getOwner());
    }
}

