/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

 /**
    @file HUDRocketFuelBar.h
    @brief Definition of the HUDRocketFuelBar class. This HUDBar displays the the amount of fuel  that a rocket has.
*/

#ifndef _HUDRocketFuelBar_H__
#define _HUDRocketFuelBar_H__

#include "overlays/OverlaysPrereqs.h"

#include "tools/interfaces/Tickable.h"
#include "weapons/projectiles/Rocket.h"
#include "HUDBar.h"

namespace orxonox
{
    class _OverlaysExport HUDRocketFuelBar : public HUDBar, public Tickable
    {
    public:
        HUDRocketFuelBar(Context* context);
        virtual ~HUDRocketFuelBar();

        virtual void tick(float dt) override;
        virtual void changedOwner() override;

    private:
        Rocket* owner_;
    };
}
#endif /* _HUDRocketFuelBar_H__ */
