/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2src/libraries/core/class/Identifier.h
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

#include "HUDRocketFuelBar.h"

#include "core/CoreIncludes.h"
#include "weapons/projectiles/Rocket.h"

namespace orxonox
{
    RegisterClass(HUDRocketFuelBar);

    HUDRocketFuelBar::HUDRocketFuelBar(Context* context) : HUDBar(context)
    {
        RegisterObject(HUDRocketFuelBar);

        this->owner_ = nullptr;
    }

    HUDRocketFuelBar::~HUDRocketFuelBar()
    {
    }

    void HUDRocketFuelBar::tick(float dt)
    {
        SUPER(HUDRocketFuelBar, tick, dt);

        if (this->owner_)
        {
            float maxFuel = this->owner_->getMaxFuel();
            if (maxFuel > 0.0)
            {
                this->setValue(this->owner_->getFuel()/maxFuel);
            }
            else
            {
                this->setValue(0.0);
            }
        }
    }

    void HUDRocketFuelBar::changedOwner()
    {
        SUPER(HUDRocketFuelBar, changedOwner);

        this->owner_ = orxonox_cast<Rocket*>(this->getOwner());
    }
}
