/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabian 'x3n' Landau
 *   Co-authors:
 *      ...
 *
 */

#include "Attacher.h"

#include "core/CoreIncludes.h"
#include "core/XMLPort.h"

namespace orxonox
{
    RegisterClass(Attacher);

    Attacher::Attacher(Context* context) : StaticEntity(context)
    {
        RegisterObject(Attacher);

        this->target_ = nullptr;
    }

    void Attacher::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(Attacher, XMLPort, xmlelement, mode);

        XMLPortParam(Attacher, "target", setTarget, getTarget, xmlelement, mode);
        XMLPortObject(Attacher, WorldEntity, "", addObject, getObject, xmlelement, mode);
    }

    void Attacher::processEvent(Event& event)
    {
        if (this->target_)
            this->target_->processEvent(event);
    }

    void Attacher::changedActivity()
    {
        SUPER(Attacher, changedActivity);

        for (WorldEntity* object : this->objects_)
            object->setActive(this->isActive());
    }

    void Attacher::changedVisibility()
    {
        SUPER(Attacher, changedVisibility);

        for (WorldEntity* object : this->objects_)
            object->setVisible(this->isVisible());
    }

    void Attacher::addObject(WorldEntity* object)
    {
        this->objects_.push_back(object);

        this->attach(object);
    }

    WorldEntity* Attacher::getObject(unsigned int index) const
    {
        unsigned int i = 0;
        for (WorldEntity* object : this->objects_)
        {
            if (i == index)
                return object;

            ++i;
        }
        return nullptr;
    }

    void Attacher::setTarget(const std::string& target)
    {
        this->targetname_ = target;
        this->target_ = nullptr;

        if (this->targetname_.empty())
            return;

        for (WorldEntity* worldEntity : ObjectList<WorldEntity>())
        {
            if (worldEntity->getName() == this->targetname_)
            {
                this->target_ = worldEntity;
                this->attachToParent(worldEntity);
            }
        }
    }

    void Attacher::loadedNewXMLName(BaseObject* object)
    {
        if (this->target_ || this->targetname_.empty())
            return;

        WorldEntity* entity = orxonox_cast<WorldEntity*>(object);
        if (entity && entity->getName() == this->targetname_)
        {
            this->target_ = entity;
            this->attachToParent(entity);
        }
    }
}
