/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Oliver Scheuss
 *   Co-authors:
 *      ...
 *
 */

#ifndef LANDISCOVERY_H
#define LANDISCOVERY_H

#include "NetworkPrereqs.h"
#include "packet/ServerInformation.h"
#include "util/Singleton.h"
#include <OgreStringConverter.h>

#include <vector>

// tolua_begin
namespace orxonox
{

  class _NetworkExport LANDiscovery
// tolua_end
    : public Singleton<LANDiscovery>
  { // tolua_export
    friend class Singleton<LANDiscovery>;
    public:
      LANDiscovery();
      ~LANDiscovery();
      void discover(); // tolua_export
      std::string getServerListItemName( unsigned int index ); // tolua_export
      std::string getServerListItemIP( unsigned int index ); // tolua_export
      std::string getServerListItemRTT( unsigned int index ); // tolua_export
      std::string getServerListItemPlayerNumber( unsigned int index ); // tolua_export
      static LANDiscovery& getInstance(){ return Singleton<LANDiscovery>::getInstance(); } // tolua_export

    private:
      static LANDiscovery* singletonPtr_s;
      ENetHost* host_;
      std::vector<packet::ServerInformation> servers_;
  }; // tolua_export

} // tolua_export

#endif // LANDISCOVERY_H
