/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Gani Aliguzhinov
 *   Co-authors:
 *      ...
 *
 */

#include "Actionpoint.h"

namespace orxonox
{
    RegisterClass(Actionpoint);

    Actionpoint::Actionpoint(Context* context) : StaticEntity(context)
    {
        RegisterObject(Actionpoint);
        
        this->actionName_ = "";
        this->name_ = "";
        
        this->bLoopStart_ = false;
        this->bLoopEnd_ = false;
        this->bProtectMe_ = false;
    }
    
    void Actionpoint::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(Actionpoint, XMLPort, xmlelement, mode);
        
        XMLPortParam(Actionpoint, "action", setActionXML, getActionXML,  xmlelement, mode);
        XMLPortParam(Actionpoint, "protect", setProtectXML, getProtectXML,  xmlelement, mode);
        XMLPortParam(Actionpoint, "attack", setAttackXML, getAttackXML,  xmlelement, mode);
        XMLPortParam(Actionpoint, "protectMe", setProtectMeXML, getProtectMeXML,  xmlelement, mode).defaultValues(false);
        XMLPortParam(Actionpoint, "loopStart", setLoopStart, getLoopStart,  xmlelement, mode).defaultValues(false);
        XMLPortParam(Actionpoint, "loopEnd", setLoopEnd, getLoopEnd,  xmlelement, mode).defaultValues(false);
    }
    /**
    @brief
        action is ATTACK -> returns name of object to attack
        action is PROTECT -> returns name of object to protect 
        if asked to protect human, returns a special string.
    @return
        name of an object to interact with.
    @note
        never use more than one of following arguments for XMLPort:
        attack, protect, protectMe or
        loopStart and loopEnd.
    */
    std::string Actionpoint::getName() const
    {
        if (this->name_ != "")
        {
            return this->name_;
        }
        else if (this->bProtectMe_)
        {
            return "reservedKeyword:human";
        }
        else
        {
            return "";
        }
    }    
}
