/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Gani Aliguzhinov
 *   Co-authors:
 *      ...
 *
 */

#include "MasterController.h"
#include "controllers/ActionpointController.h"
namespace orxonox
{

    RegisterClass(MasterController);

    //Leaders share the fact that they have Wingmans
    MasterController::MasterController(Context* context) : Controller(context)
    {
        RegisterObject(MasterController);
        this->controllers_.clear();
        this->numberOfTicksPassedSinceLastActionCall_ = 0;
        this->indexOfCurrentController_ = 0;
        this->ticks_ = 0;
    }

    MasterController::~MasterController()
    {
        this->controllers_.clear();
    } 
    /*HACK*/
    //the whole idea is a hack
    void MasterController::tick(float dt)
    {   
        if (!this->isActive())
            return;  
        ++this->ticks_;
        if (this->ticks_ == 1)
        {
            //fill the vector in the first tick
            for (ActionpointController* controller : ObjectList<ActionpointController>())
            {
                //----0ptr?----
                if (!controller)
                    continue;
                this->controllers_.push_back(controller);
            }
        }
        else
        {
            if (this->controllers_.empty())
                return;

            //iterate over vecotr with the index, keep index in boundaries 
            if (this->indexOfCurrentController_ >= this->controllers_.size())
            {
                this->indexOfCurrentController_ = 0;
            }
            //each 9 ticks index is incremented
            if (this->numberOfTicksPassedSinceLastActionCall_ >= 9)
            {
                this->numberOfTicksPassedSinceLastActionCall_ = 0;
            }

            if (this->numberOfTicksPassedSinceLastActionCall_ > 0)
            {
                if (this->numberOfTicksPassedSinceLastActionCall_ == 3)
                {
                    //check if 0ptr
                    if (!this->controllers_.at(this->indexOfCurrentController_))
                    {
                        this->controllers_.erase(this->controllers_.begin() + this->indexOfCurrentController_);
                        return;
                    }
                    //call maneuver for current index
                    this->controllers_.at(this->indexOfCurrentController_)->maneuver();
                }
                else if (this->numberOfTicksPassedSinceLastActionCall_ == 6)
                {
                    //check if 0ptr
                    if (!this->controllers_.at(this->indexOfCurrentController_))
                    {
                        this->controllers_.erase(this->controllers_.begin() + this->indexOfCurrentController_);
                        return;
                    }
                    //call canFire for current index
                    this->controllers_.at(this->indexOfCurrentController_)->bShooting_ = this->controllers_.at(this->indexOfCurrentController_)->canFire();   
                }
                ++this->numberOfTicksPassedSinceLastActionCall_;
            }
            else
            {
                //check if 0ptr
                if (!this->controllers_.at(this->indexOfCurrentController_))
                {
                    this->controllers_.erase(this->controllers_.begin() + this->indexOfCurrentController_);
                    return;
                }
                //call action for current index
                this->controllers_.at(this->indexOfCurrentController_)->action();   
                 
                //bCopyOrientation makes ship oscillate like crazy if set to true all the time.s
                this->controllers_.at(this->indexOfCurrentController_)->bCopyOrientation_ = this->ticks_ % 3 == 0;

                ++this->numberOfTicksPassedSinceLastActionCall_;
                ++this->indexOfCurrentController_;
            }
        }
    }
}
