/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

/**
    @file FlameGunProjectile.h
    @brief Implementation of the FlameGunProjectile class.
*/

#include "FlameGunProjectile.h"

#include "core/CoreIncludes.h"
#include "core/command/Executor.h"
#include "util/Convert.h"
#include "util/Math.h"

namespace orxonox
{
    RegisterClass(FlameGunProjectile);

    FlameGunProjectile::FlameGunProjectile(Context* context) : ParticleProjectile(context)
    {
        RegisterObject(FlameGunProjectile);

        this->lifetime_ = 1.0f;
        this->spread_ = 0.1f;

        setDestroyAfterCollision(false);
        setEffect("Orxonox/fire3");
    }

    void FlameGunProjectile::setLifetime(float lifetime)
    {
        if (lifetime >= 0.0)
        {
            this->lifetime_ = lifetime;
            this->flameTimer_.setTimer(this->lifetime_, false, createExecutor(createFunctor(&FlameGunProjectile::destroy, this)));
        }
        else
        {
            this->lifetime_ = 0.0;
        }
    }

    void FlameGunProjectile::setSpread(float spread)
    {
        spread_ = spread;
    }

    bool FlameGunProjectile::processCollision(WorldEntity* otherObject, btManifoldPoint& contactPoint, const btCollisionShape* cs)
    {
        bool result = ParticleProjectile::processCollision(otherObject, contactPoint, cs);

        // Every projectile can only deal damage once.
        setDamage(0.0);
        setHealthDamage(0.0);
        setShieldDamage(0.0);

        return result;
    }
}
