/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

/**
    @file MunitionPickup.h
    @brief Declaration of the MunitionPickup class.
    @ingroup PickupItems
*/

#ifndef _MunitionPickup_H__
#define _MunitionPickup_H__

#include "pickup/PickupPrereqs.h"

#include <string>
#include <vector>

#include "pickup/Pickup.h"
#include "pickup/items/MunitionContainer.h"
#include "core/class/SubclassIdentifier.h"
#include "weaponsystem/Munition.h"

namespace orxonox
{
    /**
    @brief
        The MunitionPickup gives munition to the user (a @ref Pawn).
    */
    class _PickupExport MunitionPickup : public Pickup
    {
        public:

            MunitionPickup(Context* context); //!< Constructor.
            virtual ~MunitionPickup(); //!< Destructor.

            virtual void XMLPort(Element& xmlelement, orxonox::XMLPort::Mode mode) override; //!< Method for creating a MunitionPickup object through XML.

            virtual void changedUsed(void) override; //!< Is called when the pickup has transited from used to unused or the other way around.

            void addMunitionContainer(MunitionContainer* munitionContainer);
            MunitionContainer* getMunitionContainer(unsigned int index);

        private:            
            void initialize(void); //!< Initializes the member variables.
            Pawn* carrierToPawnHelper(void); //!< Helper to transform the PickupCarrier to a Pawn, and throw an error message if the conversion fails.
            
            std::vector<MunitionContainer*> munitionContainers_;

    };
}

#endif // _MunitionPickup_H__
