
/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

#ifndef _HUDWeaponMode_H__
#define _HUDWeaponMode_H__

#include "overlays/OverlaysPrereqs.h"

#include <map>
#include <vector>
#include <string>

#include <OgreOverlayManager.h>
#include <OgrePanelOverlayElement.h> 

#include "overlays/OrxonoxOverlay.h"
#include "overlays/OverlayText.h"
#include "tools/interfaces/Tickable.h"
#include "worldentities/pawns/Pawn.h"
#include "overlays/OverlayGroup.h"
#include "weaponsystem/ReplenishingMunition.h"
#include "weaponsystem/WeaponMode.h"
#include "weaponsystem/Munition.h"

namespace orxonox
{
    class _OverlaysExport HUDWeaponMode : public OrxonoxOverlay, public Tickable
    {
    public:
        HUDWeaponMode(Context* context);
        virtual ~HUDWeaponMode();

        virtual void tick(float dt) override;
        virtual void changedOwner() override;
        virtual void changedOverlayGroup() override;
        virtual void changedVisibility() override;
        virtual void changedName() override;
        virtual void positionChanged() override;
        virtual void sizeChanged() override;

        void setWeaponMode(WeaponMode* weaponMode);

        inline void setWeaponModeHUDActualSize(Vector2 vector)
            { weaponModeHUDActualSize_ = vector;
              this->updateSize();
            }
        inline Vector2 getWeaponModeHUDActualSize() const
            { return weaponModeHUDActualSize_; }
        inline void setWeaponIndex(int index)
            { weaponIndex_ = index;
              this->updatePosition();
            }
        inline void setWeaponModeIndex(int index)
            { weaponModeIndex_ = index;
              this->updatePosition();
            }
        inline void setPositionOffset(Vector2 positionOffset)
            {
                this->positionOffset_ = positionOffset;
                this->updatePosition();
            }

    private:
        void updateSize();
        void updatePosition();
        void positionHUDChilds();

        WeakPtr<Pawn> owner_;
        WeakPtr<WeaponMode> weaponMode_;

        Ogre::PanelOverlayElement* overlayElementIcon_;
        Ogre::PanelOverlayElement* overlayElementReplenish_;
        Ogre::PanelOverlayElement* overlayElementMunition_;
        Ogre::PanelOverlayElement* overlayElementState_;

        std::string materialNameState_;

        StrongPtr<OverlayText> textOverlayLeft_;
        StrongPtr<OverlayText> textOverlayRight_;

        Vector2 weaponModeHUDActualSize_;
        Vector2 positionOffset_;
        int weaponIndex_;
        int weaponModeIndex_;
    };
}

#endif /* _HUDWeaponMode_H__ */
