/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

#ifndef _HUDWeapon_H__
#define _HUDWeapon_H__

#include "overlays/OverlaysPrereqs.h"

#include <map>
#include <vector>
#include <string>

#include <OgreOverlayManager.h>
#include <OgrePanelOverlayElement.h> 

#include "overlays/OrxonoxOverlay.h"
#include "tools/interfaces/Tickable.h"
#include "worldentities/pawns/Pawn.h"
#include "overlays/OverlayGroup.h"
#include "weaponsystem/Weapon.h"
#include "weaponsystem/WeaponMode.h"
#include "HUDWeaponMode.h"

namespace orxonox
{
    class _OverlaysExport HUDWeapon : public OrxonoxOverlay, public Tickable
    {
    public:
        HUDWeapon(Context* context);
        virtual ~HUDWeapon();

        virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode) override;
        virtual void tick(float dt) override;
        virtual void changedOwner() override;
        virtual void changedOverlayGroup() override;
        virtual void changedVisibility() override;
        virtual void changedName() override;
        virtual void positionChanged() override;
        virtual void sizeChanged() override;

        void setWeapon(Weapon* weapon);

        inline void setWeaponModeHUDActualSize(Vector2 vector)
            { weaponModeHUDActualSize_ = vector;
              this->updateSize();
            }
        inline Vector2 getWeaponModeHUDActualSize() const
            { return weaponModeHUDActualSize_; }
        inline void setPositionOffset(Vector2 positionOffset)
            {
                this->positionOffset_ = positionOffset;
                this->updatePosition();
            }            
        inline void setWeaponIndex(int index)
            {
                weaponIndex_ = index;
                this->updatePosition();
            }        

    private:
        void createHUDChilds();
        void positionHUDChilds();
        void destroyHUDChilds();
        void updateWeaponModeList();
        void updateSize();
        void updatePosition();

        WeakPtr<Pawn> owner_;
        WeakPtr<Weapon> weapon_;

        std::vector<WeakPtr<HUDWeaponMode>> hudWeaponModes_;

        Ogre::PanelOverlayElement* overlayElement_;

        Vector2 weaponModeHUDActualSize_;
        Vector2 positionOffset_;
        int weaponIndex_;
    };
}

#endif /* _HUDWeapon_H__ */
