/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

#include "HUDWeapon.h"

#include "core/CoreIncludes.h"
#include "core/XMLPort.h"
#include "util/Convert.h"
#include "core/class/Super.h"

namespace orxonox
{
    RegisterClass(HUDWeapon);

    HUDWeapon::HUDWeapon(Context* context) : OrxonoxOverlay(context)
    {
        RegisterObject(HUDWeapon);

        weaponModeHUDActualSize_ = Vector2(0.0f,0.0f);

        weaponIndex_ = 0;
        hudWeaponModes_.clear();

        overlayElement_ = static_cast<Ogre::PanelOverlayElement* >(Ogre::OverlayManager::getSingleton().createOverlayElement("Panel", "HUDWeapon" + getUniqueNumberString()));
        overlayElement_->setMaterialName("Orxonox/WSHUD_Weapon");
        overlayElement_->setPosition(0.0f,0.0f);
        overlayElement_->setDimensions(1.0f,1.0f);
        this->background_->addChild(overlayElement_);
    }

    HUDWeapon::~HUDWeapon()
    {
        if (this->isInitialized())
        {
            destroyHUDChilds();
        }
    }

    void HUDWeapon::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(HUDWeapon, XMLPort, xmlelement, mode);

        /*XMLPortParam(HUDWeapons, "sensitivity", setRadarSensitivity, getRadarSensitivity, xmlelement, mode);
        XMLPortParam(HUDWeapons, "halfDotSizeDistance", setHalfDotSizeDistance, getHalfDotSizeDistance, xmlelement, mode);*/
    }

    void HUDWeapon::tick(float dt)
    {
        SUPER(HUDWeapon, tick, dt);

        if (!weapon_)
        {
            // TODO: destroy this HUD id the Weapon does no more exist. (Wehen the weak pointer is null)
        }
    }    

    void HUDWeapon::positionChanged()
    {
        OrxonoxOverlay::positionChanged();

        positionHUDChilds();
    }

    void HUDWeapon::sizeChanged()
    {
        OrxonoxOverlay::sizeChanged();

        positionHUDChilds();
    }

    void HUDWeapon::changedOwner()
    {
        SUPER(HUDWeapon, changedOwner);

        this->owner_ = orxonox_cast<Pawn*>(this->getOwner());

        updateWeaponModeList();
    }

    void HUDWeapon::changedOverlayGroup()
    {
        SUPER(HUDWeapon, changedOverlayGroup);
    }   

    void HUDWeapon::changedVisibility()
    {
        SUPER(HUDWeapon, changedVisibility);

        bool visible = this->isVisible();

        for (HUDWeaponMode* hudWeaponMode : hudWeaponModes_)
        {
            hudWeaponMode->changedVisibility(); //inform all Child Overlays that our visibility has changed
            hudWeaponMode->setVisible(visible);
        }
    }

    void HUDWeapon::changedName()
    {
        SUPER(HUDWeapon, changedName);
    }

    void HUDWeapon::setWeapon(Weapon* weapon)
    {
        weapon_ = weapon;

        if (!weapon_)
        {
            return;
        }

        updateWeaponModeList();
    }

    void HUDWeapon::updateWeaponModeList()
    {
        if (owner_ == nullptr || weapon_ == nullptr)
        {
            return;
        }
            
        destroyHUDChilds();

        updateSize();
        createHUDChilds();
        positionHUDChilds();
    }  

    void HUDWeapon::createHUDChilds()
    {
        if (weapon_ == nullptr)
        {
            return;
        }

        int positionIndex = 0;

        for (const auto& mapEntry : weapon_->getAllWeaponmodes())
        {
            HUDWeaponMode* hudWeaponMode = new HUDWeaponMode(this->getContext());
            hudWeaponMode->setOwner(owner_);
            hudWeaponMode->setOverlayGroup(this->getOverlayGroup());
            hudWeaponMode->setVisible(this->isVisible());
            hudWeaponMode->setWeaponMode(mapEntry.second);
            hudWeaponMode->setWeaponIndex(this->weaponIndex_);                    
            hudWeaponMode->setAspectCorrection(false);
            hudWeaponMode->setPickPoint(Vector2(0.0f,0.0f));

            hudWeaponModes_.push_back(hudWeaponMode);

            ++ positionIndex;
        }
    }      

    void HUDWeapon::positionHUDChilds()
    {
        int positionIndex = 0;

        for (HUDWeaponMode* hudWeaponMode : hudWeaponModes_)
        {
            hudWeaponMode->setPositionOffset(this->positionOffset_);
            hudWeaponMode->setWeaponModeIndex(positionIndex);
            hudWeaponMode->setWeaponIndex(this->weaponIndex_);
            hudWeaponMode->setWeaponModeHUDActualSize(this->weaponModeHUDActualSize_);

            ++ positionIndex;
        }
    }  

    void HUDWeapon::destroyHUDChilds()
    {
        for (HUDWeaponMode* hudWeaponMode : hudWeaponModes_)
        {
            hudWeaponMode->destroy();
        } 

        hudWeaponModes_.clear();
    }

    void HUDWeapon::updateSize()
    {
        if (weapon_ != nullptr)
        {
            this->setSize(Vector2(weaponModeHUDActualSize_.x,weaponModeHUDActualSize_.y*weapon_->getAllWeaponmodes().size()));
            updatePosition();
        }        
    }

    void HUDWeapon::updatePosition()
    {
        if (weapon_ != nullptr)
        {
            this->setPosition(Vector2(weaponModeHUDActualSize_.x*weaponIndex_,0.0f) + this->positionOffset_);
        }        
    }       
}
