/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *   Co-authors:
 *      ...
 *
 */

#ifndef _JumpCenterpoint_H__
#define _JumpCenterpoint_H__

#include "jump/JumpPrereqs.h"
#include "worldentities/StaticEntity.h"

namespace orxonox
{
    
    /**
    @brief
        @brief The JumpCenterpoint is a StaticEntity which represents the level of the minigame. All platforms, enemies and items are attached to the JumpCenterpoint.
    */
    class _JumpExport JumpCenterpoint : public StaticEntity
    {
        public:
            JumpCenterpoint(Context* context); //!< Constructor. Registers and initializes the object and checks whether the gametype is actually Jump.
            virtual ~JumpCenterpoint() {}
            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode) override; //!< Method to create a JumpCenterpoint through XML.
            void setPlatformStaticTemplate(const std::string& balltemplate)
                { this->platformStaticTemplate_ = balltemplate; }
            const std::string& getPlatformStaticTemplate() const
                { return this->platformStaticTemplate_; }
            void setPlatformHMoveTemplate(const std::string& balltemplate)
                { this->platformHMoveTemplate_ = balltemplate; }
            const std::string& getPlatformHMoveTemplate() const
                { return this->platformHMoveTemplate_; }
            void setPlatformVMoveTemplate(const std::string& balltemplate)
                { this->platformVMoveTemplate_ = balltemplate; }
            const std::string& getPlatformVMoveTemplate() const
                { return this->platformVMoveTemplate_; }
            void setPlatformDisappearTemplate(const std::string& balltemplate)
                { this->platformDisappearTemplate_ = balltemplate; }
            const std::string& getPlatformDisappearTemplate() const
                { return this->platformDisappearTemplate_; }
            void setPlatformTimerTemplate(const std::string& balltemplate)
                { this->platformTimerTemplate_ = balltemplate; }
            const std::string& getPlatformTimerTemplate() const
                { return this->platformTimerTemplate_; }
            void setPlatformFakeTemplate(const std::string& balltemplate)
                { this->platformFakeTemplate_ = balltemplate; }
            const std::string& getPlatformFakeTemplate() const
                { return this->platformFakeTemplate_; }
            void setProjectileTemplate(const std::string& newTemplate)
                { this->projectileTemplate_ = newTemplate; }
            const std::string& getProjectileTemplate() const
                { return this->projectileTemplate_; }
            void setSpringTemplate(const std::string& newTemplate)
                { this->springTemplate_ = newTemplate; }
            const std::string& getSpringTemplate() const
                { return this->springTemplate_; }
            void setRocketTemplate(const std::string& newTemplate)
                { this->rocketTemplate_ = newTemplate; }
            const std::string& getRocketTemplate() const
                { return this->rocketTemplate_; }
            void setPropellerTemplate(const std::string& newTemplate)
                { this->propellerTemplate_ = newTemplate; }
            const std::string& getPropellerTemplate() const
                { return this->propellerTemplate_; }
            void setBootsTemplate(const std::string& newTemplate)
                { this->bootsTemplate_ = newTemplate; }
            const std::string& getBootsTemplate() const
                { return this->bootsTemplate_; }
            void setShieldTemplate(const std::string& newTemplate)
                { this->shieldTemplate_ = newTemplate; }
            const std::string& getShieldTemplate() const
                { return this->shieldTemplate_; }
            void setFigureTemplate(const std::string& newTemplate)
                { this->figureTemplate_ = newTemplate; }
            const std::string& getFigureTemplate() const
                { return this->figureTemplate_; }
            void setEnemy1Template(const std::string& newTemplate)
                { this->enemy1Template_ = newTemplate; }
            const std::string& getEnemy1Template() const
                { return this->enemy1Template_; }
            void setEnemy2Template(const std::string& newTemplate)
                { this->enemy2Template_ = newTemplate; }
            const std::string& getEnemy2Template() const
                { return this->enemy2Template_; }
            void setEnemy3Template(const std::string& newTemplate)
                { this->enemy3Template_ = newTemplate; }
            const std::string& getEnemy3Template() const
                { return this->enemy3Template_; }
            void setEnemy4Template(const std::string& newTemplate)
                { this->enemy4Template_ = newTemplate; }
            const std::string& getEnemy4Template() const
                { return this->enemy4Template_; }
            void setFieldDimension(const Vector2& dimension)
                { this->width_ = dimension.x; this->height_ = dimension.y; }
            Vector2 getFieldDimension() const
                { return Vector2(this->width_, this->height_); }
            void setSectionLength(const float sectionLength)
                { this->sectionLength_ = sectionLength; }
            float getSectionLength() const
                { return sectionLength_; }
            void setPlatformSpeed(const float platformSpeed)
                { this->platformSpeed_ = platformSpeed; }
            float getPlatformSpeed() const
                { return platformSpeed_; }
            void setCameraOffset(const float cameraOffset)
                { this->cameraOffset_ = cameraOffset; }
            float getCameraOffset() const
                { return cameraOffset_; }
        private:
            void checkGametype();
            std::string platformStaticTemplate_;
            std::string platformHMoveTemplate_;
            std::string platformVMoveTemplate_;
            std::string platformDisappearTemplate_;
            std::string platformTimerTemplate_;
            std::string platformFakeTemplate_;
            std::string projectileTemplate_;
            std::string springTemplate_;
            std::string rocketTemplate_;
            std::string propellerTemplate_;
            std::string bootsTemplate_;
            std::string shieldTemplate_;
            std::string figureTemplate_;
            std::string enemy1Template_;
            std::string enemy2Template_;
            std::string enemy3Template_;
            std::string enemy4Template_;
            float width_;
            float height_;
            float sectionLength_;
            float platformSpeed_;
            float cameraOffset_;
    };
}

#endif /* _JumpCenterpoint_H__ */
