/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Manuel Meier
 *   Co-authors:
 *      ...
 *
 */

#ifndef _HoverOrigin_H__
#define _HoverOrigin_H__

#include "HoverPrereqs.h"

#include "worldentities/StaticEntity.h"

namespace orxonox
{
    
    /**
    @brief
        The HoverOrigin implements the playing field @ref orxonox::Hover "Hover" takes place in and allows for many parameters of the minigame to be set.
        The playing field resides in the x,z-plane, with the x-axis being the horizontal axis and the z-axis being the vertical axis.
        For an example, have a look at the <code>Hover.oxw</code> level file.

    */
    class _HoverExport HoverOrigin : public StaticEntity
    {
        public:
            HoverOrigin(Context* context); //!< Constructor. Registers and initializes the object and checks whether the gametype is actually Hover.
            virtual ~HoverOrigin() = default;
            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode) override; //!< Method to create a HoverOrigin through XML.
            
            inline void setNumCells(int numCells)
                { this->numCells_ = numCells; }
            inline int getNumCells() const
                { return this->numCells_; }

            inline void setCellSize(int cellSize)
                { this->cellSize_ = cellSize; }
            inline int getCellSize() const
                { return this->cellSize_; }

            inline void setCellHeight(int cellHeight)
                { this->cellHeight_ = cellHeight; }
            inline int getCellHeight() const
                { return this->cellHeight_; }

        private:
            void checkGametype();
       
            int numCells_;
            int cellSize_;
            int cellHeight_;
    };
}

#endif /* _HoverOrigin_H__ */
