#ifndef _GlowMaterialListener_H__
#define _GlowMaterialListener_H__

#include <Ogre.h>
#include <OgreMaterialManager.h>

namespace orxonox
{
    class GlowMaterialListener : public Ogre::MaterialManager::Listener
    {
        public:
            GlowMaterialListener()
            {
                mBlackMat = Ogre::MaterialManager::getSingleton().create("mGlowBlack", "Internal");
                mBlackMat->getTechnique(0)->getPass(0)->setDiffuse(0,0,0,0);
                mBlackMat->getTechnique(0)->getPass(0)->setSpecular(0,0,0,0);
                mBlackMat->getTechnique(0)->getPass(0)->setAmbient(0,0,0);
                mBlackMat->getTechnique(0)->getPass(0)->setSelfIllumination(0,0,0);

                mTransparentMat = Ogre::MaterialManager::getSingleton().create("mGlowTransparent", "Internal");
                mTransparentMat->getTechnique(0)->getPass(0)->setDiffuse(0,0,0,0);
                mTransparentMat->getTechnique(0)->getPass(0)->setSpecular(0,0,0,0);
                mTransparentMat->getTechnique(0)->getPass(0)->setAmbient(0,0,0);
                mTransparentMat->getTechnique(0)->getPass(0)->setSelfIllumination(0,0,0);
                mTransparentMat->getTechnique(0)->getPass(0)->setSceneBlending(Ogre::SBT_ADD);
                mTransparentMat->getTechnique(0)->getPass(0)->setDepthWriteEnabled(false);
            }

            Ogre::Technique* handleSchemeNotFound(unsigned short, const Ogre::String& schemeName, Ogre::Material* mat, unsigned short, const Ogre::Renderable*)
            {
                if (schemeName == "glow")
                {
                    // try to figure out if the original material is transparent. if yes, use a black transparent material, otherwise a black opaque one.
                    if (mat->isTransparent())
                        return mTransparentMat->getTechnique(0);
                    else
                        return mBlackMat->getTechnique(0);
                }
                return NULL;
            }

        private:
            Ogre::MaterialPtr mBlackMat;
            Ogre::MaterialPtr mTransparentMat;
    };
}

#endif /* _GlowMaterialListener_H__ */
