/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *       Johannes Sager
 *   Co-authors:
 *      
 *
 */

/**
     @file Discharger.cc
     @brief Definition of the Discharger class.
*/

#ifndef _Discharger_H__
#define _Discharger_H__

#include "weapons/WeaponsPrereqs.h"
#include "weaponsystem/WeaponMode.h"

namespace orxonox
{

    /**
    @brief
        Charges energy upon releasing it with a powerful discharge
    @author
        Johannes Sager
    @ingroup WeaponsWeaponModes
    */

    class _WeaponsExport Discharger : public WeaponMode
    {
        public:
            Discharger(Context* context);
            virtual ~Discharger() {}                    // declaration for the constructor

            virtual void fire() override;               // declaration of specific fire function of each weapon

        private:
            float speed_;                               // The speed of the fired projectile.
            const unsigned int thresholdOne_ = 50;      // Threshold amount of charges where the projectile changes the first time
            const unsigned int thresholdTwo_ = 100;     // Threshold amount of charges where the projectile changes the second time        
    }; 
}

#endif /* _Discharger_H__ */
