/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Johannes Sager
 *   Co-authors:
 *    
 *
 */

/**
    @file Discharger.cc
    @brief Definition of the Discharger class.
*/

#include "Discharger.h"

#include "core/CoreIncludes.h"

#include "weaponsystem/Weapon.h"
#include "weaponsystem/WeaponPack.h"
#include "weaponsystem/WeaponSystem.h"
#include "worldentities/pawns/Pawn.h"

#include "weapons/projectiles/BillboardProjectile.h"

namespace orxonox
{
    RegisterClass(Discharger);

    Discharger::Discharger(Context* context) : WeaponMode(context)
    {
        RegisterObject(Discharger);

        this->reloadTime_ = 3.14159f;           // how long you cannot charge after fire
        this->damage_ = 0.0f;                   // if 0.0f then it uses weaponsettings.oxi
        this->speed_ = 100.0f;                  // base projectile speed
        this->chargeable_ = true;               // true if weapon chargeable

        this->setMunitionName("LaserMunition");
        this->setFireSound("sounds/Weapon_LaserFire.ogg");
        this->setReloadSound("sounds/Reload_LaserFire.ogg", 0.8);

        hudImageString_ = "Orxonox/WSHUD_WM_LaserFire";
    }

    void Discharger::fire()
    {
        BillboardProjectile* projectile = new BillboardProjectile(this->getContext());

        if(this->charges_ < this->thresholdOne_)
        {
            projectile->setMaterial("Flares/lensflare");
        }
        else
        {
            if(this->charges_ < this->thresholdTwo_)
            {
                projectile->setMaterial("Flares/ringflare");
            }
            else
            {
                projectile->setMaterial("Flares/ringflare2");  
            }
        }

        projectile->setScale(1+this->charges_/10);

        this->computeMuzzleParameters(this->getWeapon()->getWeaponPack()->getWeaponSystem()->getPawn()->getAimPosition());
        projectile->setOrientation(this->getMuzzleOrientation());
        projectile->setPosition(this->getMuzzlePosition());
        projectile->setVelocity(this->getMuzzleDirection() * this->speed_ * this->charges_ / 5);// we scale the projectile speed with the current charges / 5
        projectile->setShooter(this->getWeapon()->getWeaponPack()->getWeaponSystem()->getPawn());
        projectile->setDamage(this->getDamage() * this->charges_);
        projectile->setShieldDamage(this->getShieldDamage() * this->charges_);                  // we scale both types of damage with the current charges as
        projectile->setHealthDamage(this->getHealthDamage() * this->charges_);                  // well since this is the whole purpose of a chareable weapon
        this->charges_ = 0;                                                                     // firing "consumes" the current charges (reset after fire)
    }
}